/// <reference types="node" />
import * as querystring from 'querystring';
export declare function normalize<T = {}, U = Function>(optionsOrCallback?: T | U, cb?: U): {
    options: T;
    callback: U;
};
/**
 * Flatten an object into an Array of arrays, [[key, value], ..].
 * Implements Object.entries() for Node.js <8
 * @internal
 */
export declare function objectEntries<T>(obj: {
    [key: string]: T;
}): Array<[string, T]>;
/**
 * Encode `str` with encodeURIComponent, plus these
 * reserved characters: `! * ' ( )`.
 *
 * @see [MDN: fixedEncodeURIComponent]{@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent}
 *
 * @param {string} str The URI component to encode.
 * @return {string} The encoded string.
 */
export declare function fixedEncodeURIComponent(str: string): string;
/**
 * URI encode `uri` for generating signed URLs, using fixedEncodeURIComponent.
 *
 * Encode every byte except `A-Z a-Z 0-9 ~ - . _`.
 *
 * @param {string} uri The URI to encode.
 * @param [boolean=false] encodeSlash If `true`, the "/" character is not encoded.
 * @return {string} The encoded string.
 */
export declare function encodeURI(uri: string, encodeSlash: boolean): string;
/**
 * Serialize an object to a URL query string using util.encodeURI(uri, true).
 * @param {string} url The object to serialize.
 * @return {string} Serialized string.
 */
export declare function qsStringify(qs: querystring.ParsedUrlQueryInput): string;
export declare function objectKeyToLowercase<T>(object: {
    [key: string]: T;
}): {
    [key: string]: T;
};
