import multer from "multer";

const upload = multer({
  storage: multer.memoryStorage(),
  fileFilter: (req, file, cb) => {
    const allowed = /\.(jpe?g|png|gif|webp)$/i;
    cb(null, allowed.test(file.originalname));
  },
  limits: {
    fileSize: 5 * 1024 * 1024, // 5 MB per file
    files: 10,                 // Max 10 files
  },
});

export default upload;