import { Request, Response, NextFunction } from 'express';
import admin from 'firebase-admin';

export async function verifyToken(req: Request, res: Response, next: NextFunction) {
  
  const authHeader = req.headers.authorization;
  console.log("hit verify", authHeader)
  if (!authHeader?.startsWith('Bearer ')) {
    return res.status(401).json({ error: 'No token provided' });
  }

  const token = authHeader.split('Bearer ')[1];

  try {
    const decoded = await admin.auth().verifyIdToken(token);
    req.user = decoded; // Attach user to request
    next();
  } catch (error) {
    console.error('Token verification failed:', error);
    return res.status(401).json({ error: 'Invalid or expired token' });
  }
}