export interface Log {
  id?: string;
  logPageNo: string;
  status: number;
  createdBy: string;
  createdAt?: any;
  updatedAt?: any;
  updatedBy?: string;
}

export interface LogItem {
  id?: string;
  logId: string;
  displayNumber: number;
  raisedBy: string;
  class: string;
  defectDetails: string;
  actionDetails: string;
  ddChecked: boolean;
  ddAction: string;
  ddType: string;
  ddNo: string;
  melCdlRef: string;
  cat: string;
  indInspChecked: boolean;
  sdr: boolean;
  mmsgFc: string;
  ata: string;
  shortSignAuthId?: string;
  shortSignAuthName?: string;
  actionAuthId?: string;
  actionAuthName?: string;
  createdAt?: any;
  updatedAt?: any;
}

export interface LogComponent {
  id?: string;
  logItemId: string;
  partNo: string;
  serialOn: string;
  partOff: string;
  serialOff: string;
  grn: string;
  createdAt?: any;
  updatedAt?: any;
}

export interface Deferral {
  id?: string;
  ddNo: string;
  entries: DeferralEntry[];
  createdBy: string;
  createdAt?: any;
  updatedAt?: any;
  updatedBy?: string;
}

export interface DeferralEntry {
  defect_reference: {
    date: string;
    dd_action: string;
    dd: string;
    log_item_no: string;
    log_page: string;
    mel_cat: string;
    mel_cd_ref: string;
    type_no: string;
  };
  description: string;
  clear_reference: {
    clearedSign: string;
    clearedAuth: string;
    clearedAuthName: string;
    clearedDate: string;
  };
  enteredSign: string;
  enteredAuth: string;
  enteredAuthName: string;
  enteredDate: string;
  expDate: string;
  deferral: boolean;
}
 
export interface DeferralHistory {
  id?: string;
  deferralId: string; 
  logItemId: string;
  ddNo: string;
  action: string;
  description: string;
  data: any;
  createdBy: string;
  createdAt?: any;
}