import { Router } from "express";
import DamageController from "../../controller/damageController";
import upload from "../../middleware/damageUploadMiddleware";
import { verifyToken } from "../../middleware/verifyToken";

export default class DamageRouter {
    readonly router: Router = Router();
    readonly controller: DamageController = new DamageController();
    
    constructor() {
        this.initRoutes();
    }

    initRoutes() {
        this.router.use(verifyToken);
        this.router.post('/', upload.array("files"), this.controller.create);
        this.router.get('/', this.controller.getAll);
        this.router.get('/:id', this.controller.getOne);
        this.router.put('/:id', this.controller.update);
        this.router.delete('/:id', this.controller.delete);
        this.router.get('/status/:status', this.controller.getByStatus);
    }
}