// src/routes/deviceRouter.ts
import { Router } from "express";
import DeviceController from "../../controller/deviceController";
import { verifyToken } from "../../middleware/verifyToken";

export default class DeviceRouter {
    readonly router: Router = Router();
    readonly controller: DeviceController = new DeviceController();
    
    constructor() {
        this.initRoutes();
    }
    
    initRoutes() {
        // TEMPORARY: Disable token authentication for device routes
        // TODO: Re-enable verifyToken middleware once token issues are resolved
        this.router.use(verifyToken);

        this.router.post('/', this.controller.create);
        this.router.get('/', this.controller.getAll);
        this.router.get('/:id', this.controller.getOne);
        this.router.put('/:id', this.controller.update);
        this.router.delete('/:id', this.controller.delete);
    }
}