import { Router } from "express";
import DocumentController from "../../controller/documentController";
import upload from "../../middleware/s3UploadMiddleware";
import { verifyToken } from "../../middleware/verifyToken";

export default class DocumentRouter {
    readonly router: Router = Router();
    readonly controller: DocumentController = new DocumentController();
    
    constructor() {
        this.initRoutes();
    }

    initRoutes() {
        this.router.use(verifyToken);
        this.router.post('/', upload.single("file"), this.controller.create);
        this.router.get('/', this.controller.getAll);
        this.router.delete('/:id', this.controller.delete);
    }
}