import { Router } from "express";
import LogController from "../../controller/logsController";
import FluidsController from "../../controller/fluidsController";
import CheckController from "../../controller/checkController";
import { verifyToken } from "../../middleware/verifyToken";

export default class LogRouter {
    readonly router: Router = Router();
    readonly controller: LogController = new LogController();
    readonly fluidsController: FluidsController = new FluidsController();
    readonly checkController: CheckController = new CheckController();
    
    constructor() {
        this.initRoutes();
    }

    initRoutes() {
        this.router.use(verifyToken);
        // Existing log routes
        this.router.post('/save', this.controller.saveLog);
        this.router.get('/', this.controller.getAll);
        this.router.get('/:id', this.controller.getOne);
        this.router.put('/:id', this.controller.update);
        this.router.delete('/:id', this.controller.delete);
        this.router.post('/:logId/items', this.controller.addOrUpdateLogItem);
        this.router.delete('/:logId/items/:itemId', this.controller.deleteLogItem);
        
        // Fluids routes
        this.router.post('/:logId/fluids', this.fluidsController.saveFluids);
        this.router.get('/:logId/fluids', this.fluidsController.getFluids);
        
        // Check routes
        this.router.post('/:logId/checks', this.checkController.saveChecks);
        this.router.get('/:logId/checks', this.checkController.getChecks);
    }
}