'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('property_taxes', {
      id: {
        type: Sequelize.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
      },
      property_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      tax_type: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      frequency: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      amount: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      next_payment_due_date: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      reminder_before_due: {
        type: Sequelize.STRING(500),
        allowNull: true,
      },
      status: {
        type: Sequelize.BOOLEAN,
        defaultValue: false,
        allowNull: true,
      },
      vendor_id: {
        type: Sequelize.STRING(55),
        allowNull: true,
      },
      payment_method: {
        type: Sequelize.STRING(55),
        allowNull: true,
      },
      payment_detail: {
        type: Sequelize.STRING(550),
        allowNull: true,
      },
      payment_date: {
        type: Sequelize.STRING(250),
        allowNull: true,
      },
      payment_ref: {
        type: Sequelize.STRING(100),
        allowNull: true,
      },
      created_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('property_taxes');
  },
};