'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('revenue_received', {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: Sequelize.INTEGER
      },
      tenant_id: {
        type: Sequelize.INTEGER,
        allowNull: false,
      },
      invoice_ids: {
        type: Sequelize.JSON,
        allowNull: true,
      },
      payment_mode: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
      },
      cheque_number: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      routing_number: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      cheque_due_date: {
        type: Sequelize.DATE,
        allowNull: true,
      },
      cheque_status: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      card_number: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      account_number: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      barter_description: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      zelle_description: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      created_by: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      created_date: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
      },
      updated_date: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
      }
    });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('revenue_received');
  }
};
