'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('employee_attendance', {
      id: {
        type: Sequelize.INTEGER.UNSIGNED,
        autoIncrement: true,
        primaryKey: true
      },
      unit_id: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: true
      },
      employee_id: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false
      },
      clock_in_time: {
        type: Sequelize.DATE,
        allowNull: true
      },
      clock_out_time: {
        type: Sequelize.DATE,
        allowNull: true
      },
      working_from: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      late: {
        type: Sequelize.BOOLEAN,
        allowNull: true,
        defaultValue: false
      },
      half_day: {
        type: Sequelize.BOOLEAN,
        allowNull: true,
        defaultValue: false
      },
      overwrite_attendance: {
        type: Sequelize.BOOLEAN,
        allowNull: true,
        defaultValue: false
      },
      date: {
        type: Sequelize.DATEONLY,  // Use DATEONLY for date without time
        allowNull: true,
      },
      status: {
        type: Sequelize.STRING(50), // Or whatever length suits your status values
        allowNull: true, 
      },
      added_by: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: true
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    }); 
  },

  async down(queryInterface, Sequelize) { 
    await queryInterface.dropTable('employee_attendance');
  }
};
