/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Checks = sequelize.define('checks', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    vendor_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    bank_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    available_balance: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    street: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    suit: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    zip: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    check_no: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    total_amount: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    payment_date: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    invoice_number: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    remaining_balance: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    send_email: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    print_check: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    unit_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'checks',
  });

  Checks.associate = (models) => {
    Checks.hasMany(models.check_items, {
      foreignKey: 'check_id',
      as: 'items',
    });

    
    Checks.belongsTo(models.vendor, {
      foreignKey: 'vendor_id',
      as: 'vendor',
    });

    
    Checks.belongsTo(models.NewBank, {
      foreignKey: 'bank_id',
      as: 'bank',
    });
  };

 

return Checks;
};
