/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Services = sequelize.define('client_service', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED, 
      allowNull: true, 
    },
    code: { 
      type: DataTypes.STRING(255), 
      allowNull: false, 
    },
    name: {
      type: DataTypes.STRING(50),
      allowNull: true, 
    }, 
    price: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true, 
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'services',
  });

  return Services;
};
