module.exports = function (sequelize, DataTypes) {
  return sequelize.define('file_archive', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    unit_id: {
      type: DataTypes.INTEGER(11),
      allowNull: false,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    filename: {
      type: DataTypes.STRING(256),
      allowNull: false
    },
    size: {
      type: DataTypes.INTEGER(11),
      allowNull: false
    },
    path: {
      type: DataTypes.STRING(256),
      allowNull: false
    },
    s3_bucket: {
      type: DataTypes.STRING(32),
      allowNull: false
    },
    // ✅ Add external_reference
    external_reference: {
      type: DataTypes.STRING(64),
      allowNull: true
    },
    // ✅ Add type
    type: {
      type: DataTypes.INTEGER(11),
      allowNull: false,
      defaultValue: 0
    },
    description: {
      type: DataTypes.STRING(256),
      allowNull: true
    },
    user_id: {
      type: DataTypes.INTEGER(11),
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true
    }
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'file_archive'
  });
}
