module.exports = function(sequelize, DataTypes) {
  return sequelize.define('login_attempt', {
    email: {
      type: DataTypes.STRING(191),
      allowNull: false,
      primaryKey: true,
    },
    count: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      defaultValue: 0
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  },
  {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'login_attempts'
  })
}