module.exports = function (sequelize, DataTypes) {
  const ProjectTimeLog = sequelize.define('project_time_logs', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    }, 
    user_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    project_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    task_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    start_time: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    end_time: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    total_time: {
      type: DataTypes.CHAR(50),
      allowNull: true,
    },
    memo: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'project_time_logs',
  });

  ProjectTimeLog.associate = (models) => {
    ProjectTimeLog.belongsTo(models.projects, {
      foreignKey: 'project_id', 
      targetKey: 'id',
      as: 'project',
    }); 
    ProjectTimeLog.belongsTo(models.tasks, {
      foreignKey: 'task_id',
      targetKey: 'id',
      as: 'task',
    });
    ProjectTimeLog.belongsTo(models.user, {
      foreignKey: 'user_id',
      targetKey: 'id',
      as: 'user',
    });
  };
 
  return ProjectTimeLog;
};