/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const PropertyItem = sequelize.define('property_item', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    property_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    included_excluded_status: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    amount: {
      type: DataTypes.DOUBLE(15, 2),
      allowNull: true,
    },
    item_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    item_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    appliance_brand: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    appliance_model: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    warranty_start_date: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    warranty_end_date: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    appliance_description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    utility_provider_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    utility_description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    other_description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      defaultValue: null,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'property_items',
    paranoid: false, // soft delete enabled
  });

  return PropertyItem;
};
