module.exports = (sequelize, DataTypes) => {
  const task_employee = sequelize.define('task_employee', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
    },
    task_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'tasks',
        key: 'id',
      },

    },
    employee_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'employees',
        key: 'id',
      },

    },
  }, {
    tableName: 'task_employee',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at',
  });

  task_employee.associate = (models) => {
    task_employee.belongsTo(models.tasks, {
      foreignKey: 'task_id',
      as: 'task',
      onDelete: 'CASCADE',
    });
    task_employee.belongsTo(models.employee, {
      foreignKey: 'employee_id',
      as: 'employee',
    });
  };

  return task_employee;
};
