module.exports = function (sequelize, DataTypes) {
  const Task = sequelize.define('tasks', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    estimated_hours: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    category: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    project: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    start_date: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    end_date: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    updatedAt: {
      field: 'updated_at', 
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'tasks',
  }); 

  Task.associate = (models) => {
    Task.belongsTo(models.projects, {
      foreignKey: 'project',
      targetKey: 'id',
      as: 'projectInfo',
    });
    Task.hasMany(models.task_employee, {
      foreignKey: 'task_id',
      as: 'taskEmployees',
      onDelete: 'CASCADE', // This ensures deletion cascades
    });
    Task.hasMany(models.task_notes, {
      foreignKey: 'task_id',
      as: 'taskNotes',
      onDelete: 'CASCADE',
    });
    Task.hasMany(models.task_comments, {
      foreignKey: 'task_id',
      as: 'taskComments',
      onDelete: 'CASCADE',
    });
    Task.hasMany(models.task_history, {
      foreignKey: 'task_id',
      as: 'taskHistory',
      onDelete: 'CASCADE',
    });
    Task.hasMany(models.sub_tasks, {
      foreignKey: 'task_id',
      as: 'subTasks',
      onDelete: 'CASCADE',
    });
  }; 

  return Task;
};
