module.exports = function (sequelize, DataTypes) {
  const TenantRecurringInvoices = sequelize.define('tenant_recurring_invoices', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    }, 
    recurring_invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'recurring_invoices',
        key: 'id',
      },
    },
    tenant_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'tenants',
        key: 'id',
      },
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'tenant_recurring_invoices',
  });

  TenantRecurringInvoices.associate = function (models) {
    TenantRecurringInvoices.belongsTo(models.recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'recurring_invoice',
    });
    TenantRecurringInvoices.belongsTo(models.tenants, {
      foreignKey: 'tenant_id',
      as: 'tenant',
    });
  };

  return TenantRecurringInvoices;
};