module.exports = function(sequelize, DataTypes) {
  var user = sequelize.define('user', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true 
    },
    name: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    nick: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    email: {
      type: DataTypes.STRING(191),
      allowNull: false,
      unique: true
    },
    password: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    user_pass: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    cutoff_date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    user_group_id: {
      type: DataTypes.INTEGER(11),
      allowNull: false
    },
    status: {
      type: DataTypes.STRING(191),
      allowNull: false,
      defaultValue: 'Active'
    },
    remember_token: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    face_embedding: {                // <-- added
      type: DataTypes.TEXT,
      allowNull: true
    },
    device_id: {                // <-- added
      type: DataTypes.TEXT,
      allowNull: true
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  },
  {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'users_new'
  });

  // Associations
  user.associate = function(models) {
    models.user.hasOne(models.user_group, { foreignKey: 'user_id', sourceKey: 'id' });
    models.user.hasMany(models.unit_user, { foreignKey: 'user_id', sourceKey: 'id' });
  }

  return user;
}
