module.exports = (sequelize, DataTypes) => {
  const Vendor = sequelize.define("vendor", {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    vendor_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    vendor_type_id: {
      type: DataTypes.INTEGER,  
      allowNull: true,
    },
    opening_balance: {
      type: DataTypes.DECIMAL(15, 2),
      allowNull: false,
      defaultValue: 0,
    },
    as_of_date: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    date_of_birth: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    company_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    name_prefix: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    first_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    middle_initial: {
      type: DataTypes.STRING(5),
      allowNull: true,
    },
    last_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    job_title: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    phone: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    work_phone: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    mobile: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    fax: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    cc_email: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    website: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    other: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    billed_street: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    billed_suite: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    billed_zip: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    billed_city: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    billed_state: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shipped_street: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shipped_suite: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shipped_zip: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shipped_city: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shipped_state: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "active",
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
  },
    {
      tableName: "vendors",
      timestamps: true,
      underscored: true,
    }
  );

  Vendor.associate = (models) => {
    Vendor.belongsTo(models.vendor_type, {
      foreignKey: "vendor_type_id",
      as: "vendor_type"
    });
  };

  return Vendor;
};
