// server/models/vendor_payment.js
module.exports = (sequelize, DataTypes) => {
  const VendorPaymentSetting = sequelize.define('vendor_payment', {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      vendor_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      account_no: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      credit_limit: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      print_name_on_check_as: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      payment_terms_id: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      updated_by: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
    },
    {
      tableName: "vendor_payments",
      timestamps: true,
      underscored: true, 
    } 
  );
  return VendorPaymentSetting;
};
