const models = require('./models/index.js')
const schema = require('./graphql')
const { GraphQLServer } = require('graphql-yoga')
const session = require('express-session')
const cors = require('cors')
const jwt = require('jsonwebtoken')
const http = require('http')
const https = require('https')
const express = require('express')
const bodyParser = require('body-parser')
const multer = require('multer')
const AWS = require('aws-sdk')
const fs = require('fs')
var moment = require('moment')

require('dotenv').config()

/*const corsOptions = {
  origin: '*', //frontend url
  credendials: 'include'
}*/

const context = (req) => {
  let auth = null
  console.log('headers', req.request.get('Authorization'))
  if (req.request.get('Authorization')) {
    const parts = req.request.get('Authorization').split(' ');
    if (parts.length === 2 && parts[0] === 'Bearer' && jwt.verify(parts[1], process.env.JWT_SECRET)) {
      auth = jwt.verify(parts[1], process.env.JWT_SECRET)
    }
  }
  console.log(auth)
  return {
    req: req.request,
    auth: auth
  }
}

const server = new GraphQLServer({ schema: schema, context: context })

/*
var whitelist = ['http://localhost:8080']
var corsOptionsDelegate = function (req, callback) {
  var corsOptions;
  //if (whitelist.indexOf(req.header('Origin')) !== -1) {
    corsOptions = { origin: true } // reflect (enable) the requested origin in the CORS response
  //} else {
  //  corsOptions = { origin: false } // disable CORS for this request
  //}
  console.log("cors callback:" + JSON.stringify(corsOptions))
  callback(null, cors({ origin: '*' })) // callback expects two parameters: error and options
}
*/

var corsOptions = {
  origin: '*',
  optionsSuccessStatus: 200 // some legacy browsers (IE11, various SmartTVs) choke on 204
}
server.express.use(cors(corsOptions));

/*server.express.all('*', function(req, res, next) {
  res.setHeader("Access-Control-Allow-Origin", "http://localhost:8080");
  res.setHeader("Access-Control-Allow-Credentials", true);
  console.log(res)
  next();
});*/

server.express.use(function(req, res, next) {
  if (process.env.NODE_ENV === 'production') {
    const referer = req.get('referer')
    const authorization = req.get('authorization')
    if (referer) {
      if (referer === 'https://dreambigholdings.com/' || referer.endsWith('login')) {
        console.log('not required for login')
        // next
      } else if (authorization) {
        const parts = authorization.split(' ');
        if (parts.length === 2 && parts[0] === 'Bearer' && jwt.verify(parts[1], process.env.JWT_SECRET)) {
          if (jwt.verify(parts[1], process.env.JWT_SECRET, { clockTolerance: 3600 })) {
            console.log('Authorization token found and verified')
          } else {
            console.log('Authorization token found but credentials have expired!')
            return res.status(440).json({ error: 'Credentials have expired!' });  
          }
          // next
        } else {
          console.log('Authorization Bearer token not found')
          return res.status(403).json({ error: 'No credentials sent!' });
        }
      } else {
        console.log('Autorization token not found in headers')
        return res.status(403).json({ error: 'No credentials sent!' });
      }
    } else {
      console.log('req/req.headers not found')
      return res.status(403).json({ error: 'No credentials sent!' });
    }
  }
  next();
});

// Add headers
/*
server.express.use(function (req, res, next) {

  // Website you wish to allow to connect
  res.setHeader('Access-Control-Allow-Origin', 'http://localhost:8080');

  // Request methods you wish to allow
  res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');

  // Request headers you wish to allow
  res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');

  // Set to true if you need the website to include cookies in the requests sent
  // to the API (e.g. in case you use sessions)
  res.setHeader('Access-Control-Allow-Credentials', true);

  res.set({
    'Access-Control-Allow-Origin': 'http://localhost:8080',
    'Access-Control-Allow-Headers': 'X-Requested-With,content-type',
    'Access-Control-Allow-Methods': 'GET, POST, OPTIONS, PUT, PATCH, DELETE',
    'Access-Control-Allow-Credentials': true
  });
  console.log("req/res callback")
  // Pass to next layer of middleware
  next();
});
*/

//server.express.use(cors(corsOptionsDelegate));

//server.applyMiddleware({ cors: corsOptions });

/*
server.express.use(function(req, res, next) {
  var oneof = false;
  console.log("req headers:" + JSON.stringify(req.headers))
  if(req.headers.origin) {
      res.header('Access-Control-Allow-Origin', 'http://localhost:8080');
      oneof = true;
  }
  if(req.headers['access-control-request-method']) {
      res.header('Access-Control-Allow-Methods', req.headers['access-control-request-method']);
      oneof = true;
  }
  if(req.headers['access-control-request-headers']) {
      res.header('Access-Control-Allow-Headers', req.headers['access-control-request-headers']);
      oneof = true;
  }
  if(oneof) {
      res.header('Access-Control-Max-Age', 60 * 60 * 24 * 365);
  }
  
  console.log("res header:" + JSON.stringify(res.header))

  // intercept OPTIONS method
  if (oneof && req.method == 'OPTIONS') {
      res.send(200);
  }
  else {
      next();
  }
});
*/

/*server.express.use(session({
  name: 'qid',
  secret: process.env.JWT_SECRET,
  resave: true,
  rolling: true,
  saveUninitialized: true,
  cookie: {
    secure: process.env.NODE_ENV === 'production',
    maxAge: ms('1d'),
  },
}))*/

const archiver = express();
archiver.use(cors(corsOptions));
archiver.use(bodyParser.json());

const storage = multer.diskStorage({
  destination : 'uploads/',
  filename: function (req, file, cb) {
    cb(null, file.originalname);
  }
})

const upload = multer({ storage: storage });

AWS.config.update({
    accessKeyId: 'AKIASMWFHZL2PCME4OAF',
    secretAccessKey: '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',
    region: 'us-east-2',
})

const s3 = new AWS.S3();

archiver.post('/archivefile', upload.single('file'), autheticate, (req, res) => {
  archiveFile(req.file.path,
    req.auth,
    req.body.unit_id,
    req.body.date,
    req.file.filename,
    req.file.size,
    req.body.description,
    res);
})

archiver.get('/getfile/:file_id', autheticate, (req, res) => {
  retrieveFile(req.params.file_id, res);
})

if (process.env.NODE_ENV === 'production') {
  const credentials = {
    key: fs.readFileSync('../ssl/server.key', 'utf8'),
    cert: fs.readFileSync('../ssl/certificate.crt', 'utf8'),
    ca: [fs.readFileSync('../ssl/ca_bundle.crt', 'utf8')]    
  }
  const archiveServer = https.createServer(archiver, credentials)
  models.sequelize
    .sync()
    .then(function () {
      server.start({
        https: credentials
      })
      //archiveServer.listen(4001, () => {
      //  console.log('Archiver server is running on port 4001');
      //})
    })
    .catch(function (e) {
      throw new Error(e)
    })
} else {
  const archiveServer = http.createServer(archiver)
  models.sequelize
    .sync()
    .then(function () {
      server.start(() => console.log('Server is running on http://localhost:4000'))
      archiveServer.listen(4001, () => {
        console.log('Archiver server is running on port 8000');
      })
    })
    .catch(function (e) {
      throw new Error(e)
    })
}

function archiveFile(source, auth, unitId, date, filename, size, description, res) {
  console.log(`preparing to upload [${filename}]`)
  fs.readFile(source, async function (err, filedata) {
    const user = await models.user.findByPk(auth.userId)
    const unit = await models.unit.findByPk(unitId)
    const path = unit.name + '/' + moment(date).format('YYYY/MMMM/MMM-DD')
    const key = path
    const entry = {
      unit_id: unit.id,
      date,
      filename,
      size,
      path,
      s3_bucket: 'dream.big.holdings',
      description: description,
      user_id: user.id
    }
    if (!err) {
      const putParams = {
          Bucket: 'dream.big.holdings',
          Key: key,
          Body: filedata
      }
      if (process.env.NODE_ENV === 'production') {
        s3.putObject(putParams, async function(err, data) {
          if (err) {
            console.log('Could nor upload the file. Error :', err)
            return res.send({ success: false })
          } else {
            fs.unlink(source, function(err, result) {
              if (err) console.log('error', err)
            })
            await models.file_archive.create(entry)
            console.log('Successfully uploaded the file')
            return res.send({ success: true })
          }
        })
      } else {
        await models.file_archive.create(entry)
      }
    } else {
      console.log({ 'err': err })
    }
  })
}

async function retrieveFile(fileId, res) {
  const entry = await models.file_archive.findByPk(fileId)
  if (entry) {
    if (process.env.NODE_ENV === 'production') {
      const params = {
        Bucket: 'dream-big-holdings',
        Key: entry.path + '/' + entry.filename
      }
      s3.getObject(params, function(err, data) {
        if (err){
          return res.status(400).send({success: false, err: err})
        }
        else{
          return res.send(data.Body)
        }
      })
    } else {
      res.download('uploads/' + entry.filename)
    }
  } else  {
    res.sendStatus(404)
  }
}

function autheticate(req, res, next) {
  const bearerHeader = req.headers['authorization']
  if (bearerHeader) {
    const bearer = bearerHeader.split(' ')
    const authToken = bearer[1];
    const auth = jwt.verify(authToken, process.env.JWT_SECRET)
    if (auth) {
      req.auth = auth
      next()
    } else {
      res.sendStatus(403)
    }
  } else {
    res.sendStatus(403)
  }
}
