/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Clients = sequelize.define('client', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    main_image: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    first_name: {
      type: DataTypes.STRING(255),
      allowNull: false,
    },
    last_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ssn: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    id_type: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    id_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    phone: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(255),
      allowNull: true,
      validate: {
        isEmail: true,
      },
    },
    gender: {
      type: DataTypes.ENUM('male', 'female', 'other'),
      allowNull: true,
    },
    date_of_birth: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    opening_balance: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    monthly_gross_income: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    additional_income: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    marital_status: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    ethnicity: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    corporation_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ein: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    street_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    suite_floor: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    zip_code: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    country: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    mailing_address: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    notes: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM('active', 'inactive'),
      allowNull: false,
      defaultValue: 'active',
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'client',
  });

  Clients.associate = function (models) {
    Clients.hasMany(models.client_invoices, {
      foreignKey: 'client_id',
      as: 'client_invoices',
    });
    Clients.hasMany(models.client_recurring_invoices, {
      foreignKey: 'client_id',
      as: 'client_recurring_invoices',
    });
  };
  
  return Clients;
};
