module.exports = function (sequelize, DataTypes) {
  const ClientRecurringInvoices = sequelize.define('client_recurring_invoices', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    }, 
    recurring_invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'recurring_invoices',
        key: 'id',
      },
    },
    client_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'clients',
        key: 'id',
      },
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'client_recurring_invoices',
  });

  ClientRecurringInvoices.associate = function (models) {
    ClientRecurringInvoices.belongsTo(models.recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'recurring_invoice',
    });
    ClientRecurringInvoices.belongsTo(models.client, {
      foreignKey: 'client_id',
      as: 'client',
    }); 
  };

  return ClientRecurringInvoices;
};