/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  return sequelize.define('employee_payroll', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    employee_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    employee_type: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    payroll_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    wages: {
      type: "DOUBLE(8,2)",
      allowNull: false,
      defaultValue: '0.00'
    },
    hours: {
      type: "DOUBLE(8,2)",
      allowNull: false,
      defaultValue: '0.00'
    },
    gross_wages: {
      type: "DOUBLE(8,2)",
      allowNull: false,
      defaultValue: '0.00'
    },
    employer_contribution: {
      type: "DOUBLE(8,2)",
      allowNull: false
    },
    employer_liability: {
      type: "DOUBLE(8,2)",
      allowNull: false,
      defaultValue: '0.00'
    },
    total_expense: {
      type: "DOUBLE(8,2)",
      allowNull: false,
      defaultValue: '0.00'
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  }, {
    tableName: 'employee_payrolls'
  });
};
