module.exports = (sequelize, DataTypes) => {
  const Invitation = sequelize.define("invitation", {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      autoIncrement: true,
      primaryKey: true
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false
    },
    message: {
      type: DataTypes.TEXT,
      allowNull: false
    },
    invite_link: {
      type: DataTypes.STRING,
      allowNull: false
    },
    otp_code: {
      type: DataTypes.STRING,
      allowNull: false
    },
    unit_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    }
  }, {
    tableName: "invitations",
    timestamps: false
  });

  return Invitation;
};
