module.exports = function(sequelize, DataTypes) {
  return sequelize.define('payroll_log', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    payroll_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    log: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  },
  {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'payroll_logs'
  });
};
