/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const TaskDocument = sequelize.define('task_document', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    task_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    file_archive_id: { 
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'task_documents',
  });

  TaskDocument.associate = function (models) {
    TaskDocument.belongsTo(models.file_archive, {
      foreignKey: 'file_archive_id',
      as: 'file_archive',
    });
    TaskDocument.belongsTo(models.user, {
      foreignKey: 'created_by',
      as: 'author',
      onDelete: 'SET NULL', // or 'CASCADE' if you want to delete employee too
    });
  }
  return TaskDocument;
};