module.exports = function (sequelize, DataTypes) {
  const TaskComment = sequelize.define('task_comments', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
    },
    task_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false, 
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
    },
    assigned_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    comment: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: false,
    underscored: true,
    freezeTableName: true,
    tableName: 'task_comments',
  }); 

  TaskComment.associate = function (models) {
    TaskComment.belongsTo(models.tasks, {
      foreignKey: 'task_id',
      as: 'task',
      onDelete: 'CASCADE',
    });
    TaskComment.belongsTo(models.user, {
      foreignKey: 'assigned_by',
      as: 'author',
      onDelete: 'SET NULL',
    });
  };

  return TaskComment;
};
