/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const TemporaryEmployee = sequelize.define('temporary_employee', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    first_name: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    middle_name: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    last_name: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    ssn: {
      type: DataTypes.STRING(20),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(191),
      allowNull: false,
      unique: true,
    },
    password: { 
      type: DataTypes.STRING(191),
      allowNull: false,
    }, 
    user_pass: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    phone_number: {
      type: DataTypes.STRING(20),
      allowNull: true,
    }, 
    emergency_phone_number: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    number_and_street: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    suite_floor: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    zip_code: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    country: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    gender: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    id_type: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    id_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    }, 
    face_embedding: {
      type: DataTypes.JSON,
      allowNull: true,
    },

    // ✅ New Device Columns
    device_id: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    device_model: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    device_operating_system: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
    },
    message: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true, 
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'temporary_employees',
  });

  return TemporaryEmployee;
};
