module.exports = function (sequelize, DataTypes) {
  const Tenant = sequelize.define('tenants', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    main_image: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    property_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    indi_corp_type: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    first_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    last_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    ssn: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    corporation_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    ein: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    phone: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    id_type: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    id_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    opening_balance: {
      type: DataTypes.DOUBLE(15, 2),
      defaultValue: 0.00,
    },
    gender: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    date_of_birth: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    monthly_gross_income: {
      type: DataTypes.DECIMAL(15, 2),
      allowNull: true,
    },
    additional_income: {
      type: DataTypes.DECIMAL(15, 2),
      allowNull: true,
    },
    marital_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ethnicity: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    street_number: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    suite_floor: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    zip_code: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    city: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    country: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    mailing_address: {
      type: DataTypes.STRING(5000),
      allowNull: true,
    },
    notes: {
      type: DataTypes.TEXT('long'),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'tenants',
  });

  Tenant.associate = function (models) {
    Tenant.hasMany(models.tenant_invoices, {
      foreignKey: 'tenant_id',
      as: 'tenant_invoices',
    });
    Tenant.hasMany(models.tenant_recurring_invoices, {
      foreignKey: 'tenant_id',
      as: 'tenant_recurring_invoices',
    });
  };
  
  return Tenant;
};
