module.exports = (sequelize, DataTypes) => {
  const VendorType = sequelize.define('vendor_type', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    vendor_title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    vendor_parent: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: 'active',
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
  }, {
    tableName: 'vendor_types',
    timestamps: true,
    underscored: true,
  });

  return VendorType;
};
