"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var apollo_server_core_1 = require("apollo-server-core");
var GraphiQL = require("apollo-server-module-graphiql");
function graphqlLambda(options) {
    var _this = this;
    if (!options) {
        throw new Error('Apollo Server requires options.');
    }
    if (arguments.length > 1) {
        throw new Error("Apollo Server expects exactly one argument, got " + arguments.length);
    }
    var graphqlHandler = function (event, lambdaContext, callback) { return __awaiter(_this, void 0, void 0, function () {
        var query, statusCode, gqlResponse, headers, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    query = event.httpMethod === 'POST' ? event.body : event.queryStringParameters, statusCode = null, gqlResponse = null, headers = {};
                    if (query && typeof query === 'string') {
                        query = JSON.parse(query);
                    }
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, 4, 5]);
                    return [4, apollo_server_core_1.runHttpQuery([event, lambdaContext], {
                            method: event.httpMethod,
                            options: options,
                            query: query,
                        })];
                case 2:
                    gqlResponse = _a.sent();
                    headers['Content-Type'] = 'application/json';
                    statusCode = 200;
                    return [3, 5];
                case 3:
                    error_1 = _a.sent();
                    if ('HttpQueryError' !== error_1.name) {
                        throw error_1;
                    }
                    headers = error_1.headers;
                    statusCode = error_1.statusCode;
                    gqlResponse = error_1.message;
                    return [3, 5];
                case 4:
                    callback(null, {
                        statusCode: statusCode,
                        headers: headers,
                        body: gqlResponse,
                    });
                    return [7];
                case 5: return [2];
            }
        });
    }); };
    return graphqlHandler;
}
exports.graphqlLambda = graphqlLambda;
function graphiqlLambda(options) {
    var graphiqlHandler = function (event, lambdaContext, callback) {
        var query = event.queryStringParameters;
        GraphiQL.resolveGraphiQLString(query, options, event, lambdaContext).then(function (graphiqlString) {
            callback(null, {
                statusCode: 200,
                headers: {
                    'Content-Type': 'text/html',
                },
                body: graphiqlString,
            });
        }, function (error) {
            callback(null, {
                statusCode: 500,
                body: error.message,
            });
        });
    };
    return graphiqlHandler;
}
exports.graphiqlLambda = graphiqlLambda;
//# sourceMappingURL=lambdaApollo.js.map