'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('owners', {
      id: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
      },
      main_image: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      first_name: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      last_name: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      ssn: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      phone_no: {
        type: Sequelize.STRING(20),
        allowNull: false,
      },
      email: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      company: {
        type: Sequelize.STRING(191),
        allowNull: true,
      },
      gender: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: true,
      },
      status: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: true,
      },
      street_number: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      suite_floor: {
        type: Sequelize.STRING(191),
        allowNull: true,
      },
      zip_code: {
        type: Sequelize.STRING(10),
        allowNull: false,
      },
      city: {
        type: Sequelize.STRING(100),
        allowNull: false,
      },
      state: {
        type: Sequelize.STRING(100),
        allowNull: false,
      },
      country: {
        type: Sequelize.STRING(100),
        allowNull: false,
      },
      created_by: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: true,
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: true,
      },
    });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('owners');
  }
};
