'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('employee_shifts', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
      },
      unit_id: {
        type: Sequelize.INTEGER.UNSIGNED,
        allowNull: false,
      },
      shift_name: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      shift_short_code: {
        type: Sequelize.STRING(191),
        allowNull: false,
      },
      shift_type: {
        type: Sequelize.ENUM('strict', 'flexible'),
        allowNull: false,
      },
      flexible_total_hours: {
        type: Sequelize.DOUBLE,
        allowNull: true,
      },
      flexible_auto_clockout: {
        type: Sequelize.DOUBLE,
        allowNull: true,
        defaultValue: 0,
      },
      flexible_half_day_hours: {
        type: Sequelize.DOUBLE,
        allowNull: true,
      },
      color: {
        type: Sequelize.STRING(191),
        allowNull: true,
      },
      office_start_time: {
        type: Sequelize.TIME,
        allowNull: true,
      },
      office_end_time: {
        type: Sequelize.TIME,
        allowNull: true,
      },
      auto_clock_out_time: {
        type: Sequelize.INTEGER,
        allowNull: true,
      },
      halfday_mark_time: {
        type: Sequelize.TIME,
        allowNull: true,
      },
      late_mark_duration: {
        type: Sequelize.TINYINT,
        allowNull: true,
        defaultValue: 0,
      },
      clockin_in_day: {
        type: Sequelize.TINYINT,
        allowNull: true,
        defaultValue: 0,
      },
      office_open_days: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: true,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
      },
      updated_at: { 
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
      },
    });

    // Optional index for filtering/searching by unit
    await queryInterface.addIndex('employee_shifts', ['unit_id']);
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('employee_shifts');
  }
};
