'use strict';

module.exports = {
  up: async (queryInterface, DataTypes) => {
    await queryInterface.createTable('chart_of_accounts', {
      id: {
        type: DataTypes.INTEGER.UNSIGNED,
        primaryKey: true,
        autoIncrement: true,
        allowNull: false,
      },
      type_id: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      account: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      description: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      sub_account_of: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      account_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      routing_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      check_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      opening_balance: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      tax_line_map: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      note: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      unit_id: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: DataTypes.DATE,
        allowNull: true,
      },
      updated_at: {
        type: DataTypes.DATE,
        allowNull: true,
      },
    });
  },

  down: async (queryInterface, DataTypes) => {
    await queryInterface.dropTable('chart_of_accounts');
  },
};
