/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const CheckItems = sequelize.define('check_items', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    check_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    account_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    memo: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    amount: {
      type: DataTypes.DOUBLE,
      allowNull: false,
      defaultValue: 0,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'check_items',
  });

  CheckItems.associate = (models) => {
    CheckItems.belongsTo(models.checks, {
      foreignKey: 'check_id',
      as: 'check',
    });
  };

  return CheckItems;
};
