'use strict';

module.exports = (sequelize, DataTypes) => {
  const memorized_invoice = sequelize.define('memorized_invoice', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
    },
    recurring_invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    invoice_pay_month: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    status: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal('CURRENT_TIMESTAMP'),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
    },
  }, {
    tableName: 'memorized_invoice',
    timestamps: false,
    underscored: true,
  });

  memorized_invoice.associate = function (models) {
    memorized_invoice.belongsTo(models.recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'recurring_invoice',
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    });
  };

  return memorized_invoice;
};
