/* jshint indent: 2 */

module.exports = (sequelize, DataTypes) => {
  const TaskApproved = sequelize.define('task_approved', {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    task_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    task_assign_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    from_employee_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    to_employee_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    reason: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    action: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
    },
  },
    {
      tableName: 'task_approved',
      timestamps: false,
    }
  );

  return TaskApproved;
};