"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
var _Object$getOwnPropertyDescriptor = require("@babel/runtime-corejs3/core-js-stable/object/get-own-property-descriptor");
var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");
var _WeakMap = require("@babel/runtime-corejs3/core-js-stable/weak-map");
_Object$defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResolverDate;
var _ducky = _interopRequireDefault(require("ducky"));
var GraphQL = _interopRequireWildcard(require("graphql"));
var GraphQLLanguage = _interopRequireWildcard(require("graphql/language"));
var _error = require("graphql/error");
function _getRequireWildcardCache(nodeInterop) { if (typeof _WeakMap !== "function") return null; var cacheBabelInterop = new _WeakMap(); var cacheNodeInterop = new _WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = _Object$defineProperty && _Object$getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? _Object$getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { _Object$defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
**  GraphQL-Tools-Types -- Custom Scalar Types for GraphQL-Tools
**  Copyright (c) 2016-2021 Dr. Ralf S. Engelschall <rse@engelschall.com>
**
**  Permission is hereby granted, free of charge, to any person obtaining
**  a copy of this software and associated documentation files (the
**  "Software"), to deal in the Software without restriction, including
**  without limitation the rights to use, copy, modify, merge, publish,
**  distribute, sublicense, and/or sell copies of the Software, and to
**  permit persons to whom the Software is furnished to do so, subject to
**  the following conditions:
**
**  The above copyright notice and this permission notice shall be included
**  in all copies or substantial portions of the Software.
**
**  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
**  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
**  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
**  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
**  CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
**  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
**  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*  external requirements  */

/*  Date resolver for GraphQL Tools  */
function ResolverDate(options = {}) {
  const errors = [];
  if (!_ducky.default.validate(options, "{ name: string, serialization?: string, min?: (string|Date), max?: (string|Date), fn?: function }", errors)) throw new _error.GraphQLError("[graphql-tools-types] " + `invalid parameters: ${errors.join("; ")}`, []);
  if (options.serialization === undefined) options.serialization = "string";
  if (typeof options.min === "string") options.min = new Date(options.min);
  if (typeof options.max === "string") options.max = new Date(options.max);
  const validate = (value, ast = null) => {
    if (options.min !== undefined && value.getTime() < options.min.getTime()) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + `minimum date is ${options.min.toISOString()}`, ast !== null ? [ast] : []);
    if (options.max !== undefined && value.getTime() > options.max.getTime()) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + `maximum date is ${options.max.toISOString()}`, ast !== null ? [ast] : []);
    if (options.fn !== undefined && !options.fn(value)) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + "value not valid", ast !== null ? [ast] : []);
  };
  return {
    /*  serialize value sent as output to the client  */
    __serialize: value => {
      return options.serialization === "string" ? value.toISOString() : value.getTime();
    },
    /*  parse value received as input from client  */
    __parseValue: value => {
      if (typeof value === "string" || typeof value === "number") {
        value = new Date(value);
        if (isNaN(value.getTime())) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + "invalid Date input value", []);
        validate(value);
        return value;
      } else if (typeof value === "object" && value instanceof Date) return value;else throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + "invalid Date input value (string or Date expected)", []);
    },
    /*  parse value received as literal in AST  */
    __parseLiteral: ast => {
      let value;
      if (ast.kind === GraphQLLanguage.Kind.STRING) value = GraphQL.GraphQLString.parseLiteral(ast);else if (ast.kind === GraphQLLanguage.Kind.INT) value = GraphQL.GraphQLInt.parseLiteral(ast);else throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + "invalid Date literal (string or number expected)", [ast]);
      value = new Date(value);
      if (isNaN(value.getTime())) throw new _error.GraphQLError(`[graphql-tools-types] ${options.name}: ` + "invalid Date literal (date within valid range expected)", []);
      validate(value, ast);
      return value;
    }
  };
}
