"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PortingAllPortInPage = exports.PortingAllPortInInstance = void 0;
exports.PortingAllPortInListInstance = PortingAllPortInListInstance;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../base/Page"));
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
function PortingAllPortInListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Porting/PortIn/PortInRequests`;
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["token"] !== undefined)
            data["Token"] = params["token"];
        if (params["size"] !== undefined)
            data["Size"] = params["size"];
        if (params["portInRequestSid"] !== undefined)
            data["PortInRequestSid"] = params["portInRequestSid"];
        if (params["portInRequestStatus"] !== undefined)
            data["PortInRequestStatus"] = params["portInRequestStatus"];
        if (params["createdBefore"] !== undefined)
            data["CreatedBefore"] = serialize.iso8601DateTime(params["createdBefore"]);
        if (params["createdAfter"] !== undefined)
            data["CreatedAfter"] = serialize.iso8601DateTime(params["createdAfter"]);
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PortingAllPortInPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new PortingAllPortInPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class PortingAllPortInInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.portInRequestSid = payload.port_in_request_sid;
        this.portInRequestStatus = payload.port_in_request_status;
        this.statusLastUpdatedTimestamp = payload.status_last_updated_timestamp;
        this.phoneNumbersRequested = deserialize.integer(payload.phone_numbers_requested);
        this.phoneNumbersPorted = deserialize.integer(payload.phone_numbers_ported);
        this.suggestedAction = payload.suggested_action;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            portInRequestSid: this.portInRequestSid,
            portInRequestStatus: this.portInRequestStatus,
            statusLastUpdatedTimestamp: this.statusLastUpdatedTimestamp,
            phoneNumbersRequested: this.phoneNumbersRequested,
            phoneNumbersPorted: this.phoneNumbersPorted,
            suggestedAction: this.suggestedAction,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PortingAllPortInInstance = PortingAllPortInInstance;
class PortingAllPortInPage extends Page_1.default {
    /**
     * Initialize the PortingAllPortInPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of PortingAllPortInInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new PortingAllPortInInstance(this._version, payload);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PortingAllPortInPage = PortingAllPortInPage;
