import { inspect, InspectOptions } from "util";
import Page, { TwilioResponsePayload } from "../../../base/Page";
import Response from "../../../http/response";
import V2 from "../V2";
export declare class CreateShortCodeApplicationRequest {
    /**
     * The friendly name for the short code application.
     */
    "friendlyName": string;
    /**
     * The ISO country code.
     */
    "isoCountry": string;
    "businessInformation": CreateShortCodeApplicationRequestBusinessInformation;
    "setup": CreateShortCodeApplicationRequestSetup;
}
/**
 * Business information associated with the application.
 */
export declare class CreateShortCodeApplicationRequestBusinessInformation {
    /**
     * The Compliance Profile SID for the customer-facing business profile.
     */
    "customerFacingProfile": string;
}
export declare class CreateShortCodeApplicationRequestSetup {
    "chargesApply": boolean;
}
/**
 * Options to pass to create a ApplicationInstance
 */
export interface ApplicationListInstanceCreateOptions {
    /**  */
    createShortCodeApplicationRequest: CreateShortCodeApplicationRequest;
}
/**
 * Options to pass to each
 */
export interface ApplicationListInstanceEachOptions {
    /** How many resources to return in each list page. The default is 50, and the maximum is 50. */
    pageSize?: number;
    /** Function to process each record. If this and a positional callback are passed, this one will be used */
    callback?: (item: ApplicationInstance, done: (err?: Error) => void) => void;
    /** Function to be called upon completion of streaming */
    done?: Function;
    /** Upper limit for the number of records to return. each() guarantees never to return more than limit. Default is no limit */
    limit?: number;
}
/**
 * Options to pass to list
 */
export interface ApplicationListInstanceOptions {
    /** How many resources to return in each list page. The default is 50, and the maximum is 50. */
    pageSize?: number;
    /** Upper limit for the number of records to return. list() guarantees never to return more than limit. Default is no limit */
    limit?: number;
}
/**
 * Options to pass to page
 */
export interface ApplicationListInstancePageOptions {
    /** How many resources to return in each list page. The default is 50, and the maximum is 50. */
    pageSize?: number;
    /** Page Number, this value is simply for client state */
    pageNumber?: number;
    /** PageToken provided by the API */
    pageToken?: string;
}
export interface ApplicationContext {
    /**
     * Fetch a ApplicationInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ApplicationInstance
     */
    fetch(callback?: (error: Error | null, item?: ApplicationInstance) => any): Promise<ApplicationInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export interface ApplicationContextSolution {
    sid: string;
}
export declare class ApplicationContextImpl implements ApplicationContext {
    protected _version: V2;
    protected _solution: ApplicationContextSolution;
    protected _uri: string;
    constructor(_version: V2, sid: string);
    fetch(callback?: (error: Error | null, item?: ApplicationInstance) => any): Promise<ApplicationInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): ApplicationContextSolution;
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
interface ApplicationPayload extends TwilioResponsePayload {
    results: ApplicationResource[];
}
interface ApplicationResource {
    sid: string;
    bundle_sid: string;
    application_requirements_sid: string;
    friendly_name: string;
    iso_country: string;
    state: string;
}
export declare class ApplicationInstance {
    protected _version: V2;
    protected _solution: ApplicationContextSolution;
    protected _context?: ApplicationContext;
    constructor(_version: V2, payload: ApplicationResource, sid?: string);
    /**
     * The unique identifier of the Short Code Application.
     */
    sid: string;
    /**
     * The Bundle SID for regulatory compliance.
     */
    bundleSid: string;
    /**
     * The Application Requirements SID.
     */
    applicationRequirementsSid: string;
    /**
     * The friendly name of the application.
     */
    friendlyName: string;
    /**
     * The ISO country code.
     */
    isoCountry: string;
    /**
     * The state of the application.
     */
    state: string;
    private get _proxy();
    /**
     * Fetch a ApplicationInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ApplicationInstance
     */
    fetch(callback?: (error: Error | null, item?: ApplicationInstance) => any): Promise<ApplicationInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        sid: string;
        bundleSid: string;
        applicationRequirementsSid: string;
        friendlyName: string;
        isoCountry: string;
        state: string;
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export interface ApplicationSolution {
}
export interface ApplicationListInstance {
    _version: V2;
    _solution: ApplicationSolution;
    _uri: string;
    (sid: string): ApplicationContext;
    get(sid: string): ApplicationContext;
    /**
     * Create a ApplicationInstance
     *
     * @param params - Body for request
     * @param headers - header params for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ApplicationInstance
     */
    create(params: CreateShortCodeApplicationRequest, headers?: any, callback?: (error: Error | null, item?: ApplicationInstance) => any): Promise<ApplicationInstance>;
    /**
     * Streams ApplicationInstance records from the API.
     *
     * This operation lazily loads records as efficiently as possible until the limit
     * is reached.
     *
     * The results are passed into the callback function, so this operation is memory
     * efficient.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ApplicationListInstanceEachOptions } [params] - Options for request
     * @param { function } [callback] - Function to process each record
     */
    each(callback?: (item: ApplicationInstance, done: (err?: Error) => void) => void): void;
    each(params: ApplicationListInstanceEachOptions, callback?: (item: ApplicationInstance, done: (err?: Error) => void) => void): void;
    /**
     * Retrieve a single target page of ApplicationInstance records from the API.
     *
     * The request is executed immediately.
     *
     * @param { string } [targetUrl] - API-generated URL for the requested results page
     * @param { function } [callback] - Callback to handle list of records
     */
    getPage(targetUrl: string, callback?: (error: Error | null, items: ApplicationPage) => any): Promise<ApplicationPage>;
    /**
     * Lists ApplicationInstance records from the API as a list.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ApplicationListInstanceOptions } [params] - Options for request
     * @param { function } [callback] - Callback to handle list of records
     */
    list(callback?: (error: Error | null, items: ApplicationInstance[]) => any): Promise<ApplicationInstance[]>;
    list(params: ApplicationListInstanceOptions, callback?: (error: Error | null, items: ApplicationInstance[]) => any): Promise<ApplicationInstance[]>;
    /**
     * Retrieve a single page of ApplicationInstance records from the API.
     *
     * The request is executed immediately.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ApplicationListInstancePageOptions } [params] - Options for request
     * @param { function } [callback] - Callback to handle list of records
     */
    page(callback?: (error: Error | null, items: ApplicationPage) => any): Promise<ApplicationPage>;
    page(params: ApplicationListInstancePageOptions, callback?: (error: Error | null, items: ApplicationPage) => any): Promise<ApplicationPage>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function ApplicationListInstance(version: V2): ApplicationListInstance;
export declare class ApplicationPage extends Page<V2, ApplicationPayload, ApplicationResource, ApplicationInstance> {
    /**
     * Initialize the ApplicationPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version: V2, response: Response<string>, solution: ApplicationSolution);
    /**
     * Build an instance of ApplicationInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload: ApplicationResource): ApplicationInstance;
    [inspect.custom](depth: any, options: InspectOptions): string;
}
export {};
