"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedNumberOrderInstance = void 0;
exports.HostedNumberOrderListInstance = HostedNumberOrderListInstance;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
function HostedNumberOrderListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/HostedNumbers/HostedNumberOrders`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["phoneNumber"] === null || params["phoneNumber"] === undefined) {
            throw new Error("Required parameter \"params['phoneNumber']\" missing.");
        }
        if (params["smsCapability"] === null ||
            params["smsCapability"] === undefined) {
            throw new Error("Required parameter \"params['smsCapability']\" missing.");
        }
        let data = {};
        data["phoneNumber"] = params["phoneNumber"];
        data["smsCapability"] = serialize.bool(params["smsCapability"]);
        if (params["accountSid"] !== undefined)
            data["accountSid"] = params["accountSid"];
        if (params["friendlyName"] !== undefined)
            data["friendlyName"] = params["friendlyName"];
        if (params["uniqueName"] !== undefined)
            data["uniqueName"] = params["uniqueName"];
        if (params["ccEmails"] !== undefined)
            data["ccEmails"] = serialize.map(params["ccEmails"], (e) => e);
        if (params["smsUrl"] !== undefined)
            data["smsUrl"] = params["smsUrl"];
        if (params["smsMethod"] !== undefined)
            data["smsMethod"] = params["smsMethod"];
        if (params["smsFallbackUrl"] !== undefined)
            data["smsFallbackUrl"] = params["smsFallbackUrl"];
        if (params["smsFallbackMethod"] !== undefined)
            data["smsFallbackMethod"] = params["smsFallbackMethod"];
        if (params["statusCallbackUrl"] !== undefined)
            data["statusCallbackUrl"] = params["statusCallbackUrl"];
        if (params["statusCallbackMethod"] !== undefined)
            data["statusCallbackMethod"] = params["statusCallbackMethod"];
        if (params["smsApplicationSid"] !== undefined)
            data["smsApplicationSid"] = params["smsApplicationSid"];
        if (params["addressSid"] !== undefined)
            data["addressSid"] = params["addressSid"];
        if (params["email"] !== undefined)
            data["email"] = params["email"];
        if (params["verificationType"] !== undefined)
            data["verificationType"] = params["verificationType"];
        if (params["verificationDocumentSid"] !== undefined)
            data["verificationDocumentSid"] = params["verificationDocumentSid"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new HostedNumberOrderInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class HostedNumberOrderInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.sid = payload.sid;
        this.accountSid = payload.accountSid;
        this.incomingPhoneNumberSid = payload.incomingPhoneNumberSid;
        this.addressSid = payload.addressSid;
        this.signingDocumentSid = payload.signingDocumentSid;
        this.phoneNumber = payload.phoneNumber;
        this.capabilities = payload.capabilities;
        this.friendlyName = payload.friendlyName;
        this.uniqueName = payload.uniqueName;
        this.status = payload.status;
        this.failureReason = payload.failureReason;
        this.dateCreated = deserialize.iso8601DateTime(payload.dateCreated);
        this.dateUpdated = deserialize.iso8601DateTime(payload.dateUpdated);
        this.verificationAttempts = deserialize.integer(payload.verificationAttempts);
        this.email = payload.email;
        this.ccEmails = payload.ccEmails;
        this.url = payload.url;
        this.verificationType = payload.verificationType;
        this.verificationDocumentSid = payload.verificationDocumentSid;
        this.extension = payload.extension;
        this.callDelay = deserialize.integer(payload.callDelay);
        this.verificationCode = payload.verificationCode;
        this.verificationCallSids = payload.verificationCallSids;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            sid: this.sid,
            accountSid: this.accountSid,
            incomingPhoneNumberSid: this.incomingPhoneNumberSid,
            addressSid: this.addressSid,
            signingDocumentSid: this.signingDocumentSid,
            phoneNumber: this.phoneNumber,
            capabilities: this.capabilities,
            friendlyName: this.friendlyName,
            uniqueName: this.uniqueName,
            status: this.status,
            failureReason: this.failureReason,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            verificationAttempts: this.verificationAttempts,
            email: this.email,
            ccEmails: this.ccEmails,
            url: this.url,
            verificationType: this.verificationType,
            verificationDocumentSid: this.verificationDocumentSid,
            extension: this.extension,
            callDelay: this.callDelay,
            verificationCode: this.verificationCode,
            verificationCallSids: this.verificationCallSids,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.HostedNumberOrderInstance = HostedNumberOrderInstance;
