const models = require('./models/index.js')
const schema = require('./graphql')
const { GraphQLServer } = require('graphql-yoga')
const session = require('express-session')
const cors = require('cors')
const ms = require('ms')
const jwt = require('jsonwebtoken')
const pubsub = require('./graphql/pubsub');
require('dotenv').config()

/*const corsOptions = {
  origin: '*', //frontend url
  credendials: 'include'
}*/

const context = (req) => {
  let auth = null
  console.log('headers', req.request.get('Authorization'))
  if (req.request.get('Authorization')) {
    const parts = req.request.get('Authorization').split(' ');
    if (parts.length === 2 && parts[0] === 'Bearer' && jwt.verify(parts[1], process.env.JWT_SECRET)) {
      auth = jwt.verify(parts[1], process.env.JWT_SECRET)
    }
  }
  console.log(auth)
  return {
    req: req.request,
    auth: auth
  }
}

const server = new GraphQLServer({ schema: schema, context: context })

const subscriptionOptions = {
  onConnect: (connectionParams, webSocket, context) => {
    if (connectionParams && connectionParams.Authorization) {
      const token = connectionParams.Authorization.split(' ')[1];
      try {
        const auth = jwt.verify(token, process.env.JWT_SECRET);
        return { auth };
      } catch (err) {
        console.log('WS token verify failed:', err.message);
        throw new Error('Invalid token');
      }
    }
    return {};
  }
};


/*
var whitelist = ['http://localhost:8080']
var corsOptionsDelegate = function (req, callback) {
  var corsOptions;
  //if (whitelist.indexOf(req.header('Origin')) !== -1) {
    corsOptions = { origin: true } // reflect (enable) the requested origin in the CORS response
  //} else {
  //  corsOptions = { origin: false } // disable CORS for this request
  //}
  console.log("cors callback:" + JSON.stringify(corsOptions))
  callback(null, cors({ origin: '*' })) // callback expects two parameters: error and options
}
*/

var corsOptions = {
  origin: '*',
  //optionsSuccessStatus: 200 // some legacy browsers (IE11, various SmartTVs) choke on 204
}
server.express.use(cors(corsOptions));

/*server.express.all('*', function(req, res, next) {
  res.setHeader("Access-Control-Allow-Origin", "http://localhost:8080");
  res.setHeader("Access-Control-Allow-Credentials", true);
  console.log(res)
  next();
});*/

server.express.use(function(req, res, next) {
  if (process.env.NODE_ENV === 'production0') {
    const referer = req.get('referer') || ''
    const authorization = req.get('authorization')
    const mutation = req.get('mutation') || ''
    if (referer || mutation) {
      if (referer.endsWith('login') || mutation.endsWith('login')) {
        console.log('not required for login')
        // next
      } else if (authorization) {
        const parts = authorization.split(' ');
        if (parts.length === 2 && parts[0] === 'Bearer' && jwt.verify(parts[1], process.env.JWT_SECRET)) {
          if (jwt.verify(parts[1], process.env.JWT_SECRET, { clockTolerance: 3600 })) {
            console.log('Authorization token found and verified')
          } else {
            console.log('Authorization token found but credentials have expired!')
            return res.status(440).json({ error: 'Credentials have expired!' });  
          }
          // next
        } else {
          console.log('Authorization Bearer token not found')
          return res.status(403).json({ error: 'No credentials sent!' });
        }
      } else {
        console.log('Autorization token not found in headers')
        return res.status(403).json({ error: 'No credentials sent!' });
      }
    } else {
      console.log('req/req.headers not found')
      return res.status(403).json({ error: 'No credentials sent!' });
    }
  }
  next();
});

// Add headers
/*
server.express.use(function (req, res, next) {

  // Website you wish to allow to connect
  res.setHeader('Access-Control-Allow-Origin', 'http://localhost:8080');

  // Request methods you wish to allow
  res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');

  // Request headers you wish to allow
  res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');

  // Set to true if you need the website to include cookies in the requests sent
  // to the API (e.g. in case you use sessions)
  res.setHeader('Access-Control-Allow-Credentials', true);

  res.set({
    'Access-Control-Allow-Origin': 'http://localhost:8080',
    'Access-Control-Allow-Headers': 'X-Requested-With,content-type',
    'Access-Control-Allow-Methods': 'GET, POST, OPTIONS, PUT, PATCH, DELETE',
    'Access-Control-Allow-Credentials': true
  });
  console.log("req/res callback")
  // Pass to next layer of middleware
  next();
});
*/

//server.express.use(cors(corsOptionsDelegate));

//server.applyMiddleware({ cors: corsOptions });

/*
server.express.use(function(req, res, next) {
  var oneof = false;
  console.log("req headers:" + JSON.stringify(req.headers))
  if(req.headers.origin) {
      res.header('Access-Control-Allow-Origin', 'http://localhost:8080');
      oneof = true;
  }
  if(req.headers['access-control-request-method']) {
      res.header('Access-Control-Allow-Methods', req.headers['access-control-request-method']);
      oneof = true;
  }
  if(req.headers['access-control-request-headers']) {
      res.header('Access-Control-Allow-Headers', req.headers['access-control-request-headers']);
      oneof = true;
  }
  if(oneof) {
      res.header('Access-Control-Max-Age', 60 * 60 * 24 * 365);
  }
  
  console.log("res header:" + JSON.stringify(res.header))

  // intercept OPTIONS method
  if (oneof && req.method == 'OPTIONS') {
      res.send(200);
  }
  else {
      next();
  }
});
*/

/*server.express.use(session({
  name: 'qid',
  secret: process.env.JWT_SECRET,
  resave: true,
  rolling: true,
  saveUninitialized: true,
  cookie: {
    secure: process.env.NODE_ENV === 'production',
    maxAge: ms('1d'),
  },
}))*/


models.sequelize
  .sync()
  .then(function () {
    server.start({ port: 4000, subscriptions: subscriptionOptions }, () =>
      console.log('Server is running on http://localhost:4000')
    );
  })
  .catch(function (e) {
    throw new Error(e);
  });